package kr.kro.yewonmods.bowsword;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.object.builder.v1.client.model.FabricModelPredicateProviderRegistry;
import net.minecraft.util.Identifier;

public class BowswordClient implements ClientModInitializer {
    @Override
    public void onInitializeClient() {

        //Wooden Bow
        FabricModelPredicateProviderRegistry.register(BowswordMod.WOODEN_BOW, new Identifier("pull"), (itemStack, clientWorld, livingEntity, something) -> {
            if (livingEntity == null) {
                return 0.0F;
            }
            return livingEntity.getActiveItem() != itemStack ? 0.0F : (itemStack.getMaxUseTime() - livingEntity.getItemUseTimeLeft()) / 20.0F;
        });

        FabricModelPredicateProviderRegistry.register(BowswordMod.WOODEN_BOW, new Identifier("pulling"), (itemStack, clientWorld, livingEntity, something) -> {
            if (livingEntity == null) {
                return 0.0F;
            }
            return livingEntity.isUsingItem() && livingEntity.getActiveItem() == itemStack ? 1.0F : 0.0F;
        });

        //Wooden Crossbow
        FabricModelPredicateProviderRegistry.register(BowswordMod.WOODEN_CROSSBOW, new Identifier("pull"), (itemStack, clientWorld, livingEntity, something) -> {
            if (livingEntity == null) {
                return 0.0F;
            }
            return livingEntity.getActiveItem() != itemStack ? 0.0F : (itemStack.getMaxUseTime() - livingEntity.getItemUseTimeLeft()) / 20.0F;
        });

        FabricModelPredicateProviderRegistry.register(BowswordMod.WOODEN_CROSSBOW, new Identifier("pulling"), (itemStack, clientWorld, livingEntity, something) -> {
            if (livingEntity == null) {
                return 0.0F;
            }
            return livingEntity.isUsingItem() && livingEntity.getActiveItem() == itemStack ? 1.0F : 0.0F;
        });
    }
}
