/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.render.SpriteSheetManager;
import codechicken.lib.render.TextureDataHolder;
import codechicken.lib.render.TextureFX;
import codechicken.lib.render.TextureUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class TextureSpecial
extends TextureAtlasSprite
implements TextureUtils.IIconSelfRegister {
    private int spriteIndex;
    private SpriteSheetManager.SpriteSheet spriteSheet;
    private TextureFX textureFX;
    private int blankSize = -1;
    private ArrayList<TextureDataHolder> baseTextures;
    private boolean selfRegister;
    public int atlasIndex;

    protected TextureSpecial(String par1) {
        super(par1);
    }

    public TextureSpecial addTexture(TextureDataHolder t) {
        if (this.baseTextures == null) {
            this.baseTextures = new ArrayList();
        }
        this.baseTextures.add(t);
        return this;
    }

    public TextureSpecial baseFromSheet(SpriteSheetManager.SpriteSheet spriteSheet, int spriteIndex) {
        this.spriteSheet = spriteSheet;
        this.spriteIndex = spriteIndex;
        return this;
    }

    public TextureSpecial addTextureFX(TextureFX fx) {
        this.textureFX = fx;
        return this;
    }

    public void initSprite(int sheetWidth, int sheetHeight, int originX, int originY, boolean rotated) {
        super.initSprite(sheetWidth, sheetHeight, originX, originY, rotated);
        if (this.textureFX != null) {
            this.textureFX.onTextureDimensionsUpdate(this.width, this.height);
        }
    }

    public void updateAnimation() {
        if (this.textureFX != null) {
            this.textureFX.update();
            if (this.textureFX.changed()) {
                TextureUtil.uploadTextureMipmap((int[][])new int[][]{this.textureFX.imageData}, (int)this.width, (int)this.height, (int)this.originX, (int)this.originY, (boolean)false, (boolean)false);
            }
        }
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public void addFrame(int[] data) {
        GameSettings settings = Minecraft.getMinecraft().gameSettings;
        BufferedImage[] images = new BufferedImage[settings.mipmapLevels + 1];
        images[0] = new BufferedImage(this.width, this.height, 2);
        images[0].setRGB(0, 0, this.width, this.height, data, 0, this.width);
        super.loadSprite(images, null, settings.anisotropicFiltering > 1);
    }

    public boolean load(IResourceManager manager, ResourceLocation location) {
        if (this.baseTextures != null) {
            for (TextureDataHolder tex : this.baseTextures) {
                this.width = tex.width;
                this.height = tex.height;
                this.addFrame(tex.data);
            }
        }
        if (this.spriteSheet != null) {
            TextureDataHolder tex = this.spriteSheet.createSprite(this.spriteIndex);
            this.width = tex.width;
            this.height = tex.height;
            this.addFrame(tex.data);
        }
        if (this.blankSize > 0) {
            this.width = this.height = this.blankSize;
            this.addFrame(new int[this.blankSize * this.blankSize]);
        }
        if (this.framesTextureData.isEmpty()) {
            throw new RuntimeException("No base frame for texture: " + this.getIconName());
        }
        return false;
    }

    public boolean hasAnimationMetadata() {
        return this.textureFX != null || super.hasAnimationMetadata();
    }

    public int getFrameCount() {
        if (this.textureFX != null) {
            return 1;
        }
        return super.getFrameCount();
    }

    public TextureSpecial blank(int size) {
        this.blankSize = size;
        return this;
    }

    public TextureSpecial selfRegister() {
        this.selfRegister = true;
        TextureUtils.addIconRegistrar(this);
        return this;
    }

    @Override
    public void registerIcons(IIconRegister register) {
        if (this.selfRegister) {
            ((TextureMap)register).setTextureEntry(this.getIconName(), (TextureAtlasSprite)this);
        }
    }

    @Override
    public int atlasIndex() {
        return this.atlasIndex;
    }
}

