/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rectangle4i;
import codechicken.lib.vec.Vector3;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    static Vector3[] vectors = new Vector3[8];
    static RenderItem uniformRenderItem = new RenderItem(){

        public boolean shouldBob() {
            return false;
        }
    };
    static EntityItem entityItem;

    public static void renderFluidQuad(Vector3 point1, Vector3 point2, Vector3 point3, Vector3 point4, IIcon icon, double res) {
        RenderUtils.renderFluidQuad(point2, vectors[0].set(point4).subtract(point1), vectors[1].set(point1).subtract(point2), icon, res);
    }

    public static void renderFluidQuad(Vector3 base, Vector3 wide, Vector3 high, IIcon icon, double res) {
        double rx;
        Tessellator t = Tessellator.instance;
        double u1 = icon.getMinU();
        double du = icon.getMaxU() - icon.getMinU();
        double v2 = icon.getMaxV();
        double dv = icon.getMaxV() - icon.getMinV();
        double wlen = wide.mag();
        double hlen = high.mag();
        for (double x = 0.0; x < wlen; x += rx) {
            double ry;
            rx = wlen - x;
            if (rx > res) {
                rx = res;
            }
            for (double y = 0.0; y < hlen; y += ry) {
                ry = hlen - y;
                if (ry > res) {
                    ry = res;
                }
                Vector3 dx1 = vectors[2].set(wide).multiply(x / wlen);
                Vector3 dx2 = vectors[3].set(wide).multiply((x + rx) / wlen);
                Vector3 dy1 = vectors[4].set(high).multiply(y / hlen);
                Vector3 dy2 = vectors[5].set(high).multiply((y + ry) / hlen);
                t.addVertexWithUV(base.x + dx1.x + dy2.x, base.y + dx1.y + dy2.y, base.z + dx1.z + dy2.z, u1, v2 - ry / res * dv);
                t.addVertexWithUV(base.x + dx1.x + dy1.x, base.y + dx1.y + dy1.y, base.z + dx1.z + dy1.z, u1, v2);
                t.addVertexWithUV(base.x + dx2.x + dy1.x, base.y + dx2.y + dy1.y, base.z + dx2.z + dy1.z, u1 + rx / res * du, v2);
                t.addVertexWithUV(base.x + dx2.x + dy2.x, base.y + dx2.y + dy2.y, base.z + dx2.z + dy2.z, u1 + rx / res * du, v2 - ry / res * dv);
            }
        }
    }

    public static void translateToWorldCoords(Entity entity, float frame) {
        double interpPosX = entity.lastTickPosX + (entity.posX - entity.lastTickPosX) * (double)frame;
        double interpPosY = entity.lastTickPosY + (entity.posY - entity.lastTickPosY) * (double)frame;
        double interpPosZ = entity.lastTickPosZ + (entity.posZ - entity.lastTickPosZ) * (double)frame;
        GL11.glTranslated((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
    }

    public static void drawCuboidOutline(Cuboid6 c) {
        Tessellator var2 = Tessellator.instance;
        var2.startDrawing(3);
        var2.addVertex(c.min.x, c.min.y, c.min.z);
        var2.addVertex(c.max.x, c.min.y, c.min.z);
        var2.addVertex(c.max.x, c.min.y, c.max.z);
        var2.addVertex(c.min.x, c.min.y, c.max.z);
        var2.addVertex(c.min.x, c.min.y, c.min.z);
        var2.draw();
        var2.startDrawing(3);
        var2.addVertex(c.min.x, c.max.y, c.min.z);
        var2.addVertex(c.max.x, c.max.y, c.min.z);
        var2.addVertex(c.max.x, c.max.y, c.max.z);
        var2.addVertex(c.min.x, c.max.y, c.max.z);
        var2.addVertex(c.min.x, c.max.y, c.min.z);
        var2.draw();
        var2.startDrawing(1);
        var2.addVertex(c.min.x, c.min.y, c.min.z);
        var2.addVertex(c.min.x, c.max.y, c.min.z);
        var2.addVertex(c.max.x, c.min.y, c.min.z);
        var2.addVertex(c.max.x, c.max.y, c.min.z);
        var2.addVertex(c.max.x, c.min.y, c.max.z);
        var2.addVertex(c.max.x, c.max.y, c.max.z);
        var2.addVertex(c.min.x, c.min.y, c.max.z);
        var2.addVertex(c.min.x, c.max.y, c.max.z);
        var2.draw();
    }

    public static void renderFluidCuboid(Cuboid6 bound, IIcon tex, double res) {
        RenderUtils.renderFluidQuad(new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.max.x, bound.max.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), tex, res);
    }

    public static void renderBlockOverlaySide(int x, int y, int z, int side, double tx1, double tx2, double ty1, double ty2) {
        double[] points = new double[]{(double)x - 0.009, (double)x + 1.009, (double)y - 0.009, (double)y + 1.009, (double)z - 0.009, (double)z + 1.009};
        Tessellator tessellator = Tessellator.instance;
        switch (side) {
            case 0: {
                tessellator.addVertexWithUV(points[0], points[2], points[4], tx1, ty1);
                tessellator.addVertexWithUV(points[1], points[2], points[4], tx2, ty1);
                tessellator.addVertexWithUV(points[1], points[2], points[5], tx2, ty2);
                tessellator.addVertexWithUV(points[0], points[2], points[5], tx1, ty2);
                break;
            }
            case 1: {
                tessellator.addVertexWithUV(points[1], points[3], points[4], tx2, ty1);
                tessellator.addVertexWithUV(points[0], points[3], points[4], tx1, ty1);
                tessellator.addVertexWithUV(points[0], points[3], points[5], tx1, ty2);
                tessellator.addVertexWithUV(points[1], points[3], points[5], tx2, ty2);
                break;
            }
            case 2: {
                tessellator.addVertexWithUV(points[0], points[3], points[4], tx2, ty1);
                tessellator.addVertexWithUV(points[1], points[3], points[4], tx1, ty1);
                tessellator.addVertexWithUV(points[1], points[2], points[4], tx1, ty2);
                tessellator.addVertexWithUV(points[0], points[2], points[4], tx2, ty2);
                break;
            }
            case 3: {
                tessellator.addVertexWithUV(points[1], points[3], points[5], tx2, ty1);
                tessellator.addVertexWithUV(points[0], points[3], points[5], tx1, ty1);
                tessellator.addVertexWithUV(points[0], points[2], points[5], tx1, ty2);
                tessellator.addVertexWithUV(points[1], points[2], points[5], tx2, ty2);
                break;
            }
            case 4: {
                tessellator.addVertexWithUV(points[0], points[3], points[5], tx2, ty1);
                tessellator.addVertexWithUV(points[0], points[3], points[4], tx1, ty1);
                tessellator.addVertexWithUV(points[0], points[2], points[4], tx1, ty2);
                tessellator.addVertexWithUV(points[0], points[2], points[5], tx2, ty2);
                break;
            }
            case 5: {
                tessellator.addVertexWithUV(points[1], points[3], points[4], tx2, ty1);
                tessellator.addVertexWithUV(points[1], points[3], points[5], tx1, ty1);
                tessellator.addVertexWithUV(points[1], points[2], points[5], tx1, ty2);
                tessellator.addVertexWithUV(points[1], points[2], points[4], tx2, ty2);
            }
        }
    }

    public static boolean shouldRenderFluid(FluidStack stack) {
        return stack.amount > 0 && stack.getFluid() != null;
    }

    public static IIcon prepareFluidRender(FluidStack stack, int alpha) {
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Fluid fluid = stack.getFluid();
        CCRenderState.setColour(fluid.getColor(stack) << 8 | alpha);
        TextureUtils.bindAtlas(fluid.getSpriteNumber());
        return TextureUtils.safeIcon(fluid.getIcon(stack));
    }

    public static void postFluidRender() {
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }

    public static double fluidDensityToAlpha(double density) {
        return Math.pow(density, 0.4);
    }

    public static void renderFluidCuboid(FluidStack stack, Cuboid6 bound, double density, double res) {
        if (!RenderUtils.shouldRenderFluid(stack)) {
            return;
        }
        int alpha = 255;
        if (stack.getFluid().isGaseous()) {
            alpha = (int)(RenderUtils.fluidDensityToAlpha(density) * 255.0);
        } else {
            bound.max.y = bound.min.y + (bound.max.y - bound.min.y) * density;
        }
        IIcon tex = RenderUtils.prepareFluidRender(stack, alpha);
        CCRenderState.startDrawing();
        RenderUtils.renderFluidCuboid(bound, tex, res);
        CCRenderState.draw();
        RenderUtils.postFluidRender();
    }

    public static void renderFluidGauge(FluidStack stack, Rectangle4i rect, double density, double res) {
        if (!RenderUtils.shouldRenderFluid(stack)) {
            return;
        }
        int alpha = 255;
        if (stack.getFluid().isGaseous()) {
            alpha = (int)(RenderUtils.fluidDensityToAlpha(density) * 255.0);
        } else {
            int height = (int)((double)rect.h * density);
            rect.y += rect.h - height;
            rect.h = height;
        }
        IIcon tex = RenderUtils.prepareFluidRender(stack, alpha);
        CCRenderState.startDrawing();
        RenderUtils.renderFluidQuad(new Vector3(rect.x, rect.y + rect.h, 0.0), new Vector3(rect.w, 0.0, 0.0), new Vector3(0.0, -rect.h, 0.0), tex, res);
        CCRenderState.draw();
        RenderUtils.postFluidRender();
    }

    public static void renderItemUniform(ItemStack item) {
        RenderUtils.renderItemUniform(item, 0.0);
    }

    public static void renderItemUniform(ItemStack item, double spin) {
        IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)item, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY);
        boolean is3D = customRenderer != null && customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.ENTITY, item, IItemRenderer.ItemRendererHelper.BLOCK_3D);
        boolean larger = false;
        if (item.getItem() instanceof ItemBlock && RenderBlocks.renderItemIn3d((int)Block.getBlockFromItem((Item)item.getItem()).getRenderType())) {
            int renderType = Block.getBlockFromItem((Item)item.getItem()).getRenderType();
            larger = renderType != 1 && renderType != 19 && renderType != 12 && renderType != 2;
        } else if (is3D) {
            larger = true;
        }
        double d = 2.0;
        double d1 = 1.0 / d;
        if (larger) {
            GL11.glScaled((double)d, (double)d, (double)d);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        entityItem.setEntityItemStack(item);
        uniformRenderItem.doRender(entityItem, 0.0, larger ? 0.09 : 0.06, 0.0, 0.0f, (float)(spin * 9.0 / Math.PI));
        if (larger) {
            GL11.glScaled((double)d1, (double)d1, (double)d1);
        }
    }

    static {
        for (int i = 0; i < vectors.length; ++i) {
            RenderUtils.vectors[i] = new Vector3();
        }
        uniformRenderItem.setRenderManager(RenderManager.instance);
        entityItem = new EntityItem(null);
        RenderUtils.entityItem.hoverStart = 0.0f;
    }
}

