/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import codechicken.lib.inventory.InventoryUtils;
import com.google.common.base.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemKey
implements Comparable<ItemKey> {
    public ItemStack stack;
    private int hashcode = 0;

    public ItemKey(ItemStack k) {
        this.stack = k;
    }

    public ItemKey(Item item, int damage) {
        this(new ItemStack(item, 1, damage));
    }

    public ItemKey(Item item, NBTTagCompound tag) {
        this(item, Short.MAX_VALUE, tag);
    }

    public ItemKey(Item item, int damage, NBTTagCompound tag) {
        this(item, damage);
        this.stack.setTagCompound(tag);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemKey)) {
            return false;
        }
        ItemKey k = (ItemKey)obj;
        return this.stack.getItem() == k.stack.getItem() && InventoryUtils.actualDamage(this.stack) == InventoryUtils.actualDamage(k.stack) && Objects.equal((Object)this.stack.stackTagCompound, (Object)k.stack.stackTagCompound);
    }

    public int hashCode() {
        return this.hashcode != 0 ? this.hashcode : (this.hashcode = Objects.hashCode((Object[])new Object[]{this.stack.getItem(), InventoryUtils.actualDamage(this.stack), this.stack.stackTagCompound}));
    }

    public int compareInt(int a, int b) {
        return a == b ? 0 : (a < b ? -1 : 1);
    }

    @Override
    public int compareTo(ItemKey o) {
        if (this.stack.getItem() != o.stack.getItem()) {
            return this.compareInt(Item.getIdFromItem((Item)this.stack.getItem()), Item.getIdFromItem((Item)o.stack.getItem()));
        }
        if (InventoryUtils.actualDamage(this.stack) != InventoryUtils.actualDamage(o.stack)) {
            return this.compareInt(InventoryUtils.actualDamage(this.stack), InventoryUtils.actualDamage(o.stack));
        }
        return 0;
    }
}

